# 🐾 FurryOS Gen2.1_v2: Sovereign Universe

**Version:** Gen2.1_v2-Final
**Base:** Debian 13 (Trixie/Testing)
**Architecture:** x86_64
**License:** MIT
**Lead Architect:** Thomas B. Sweet (Anthro Entertainment LLC)

---

## 🏗 Project Overview

FurryOS is a "Distro-as-Code" project designed to provide a highly customized, user-sovereign operating system based on Debian 13. Unlike traditional distributions that rely on manual installation, FurryOS is built using an automated pipeline that injects specialized configurations, assets, and security profiles directly into a Live ISO environment.

### Core Philosophy

- **User Sovereignty:** Zero telemetry by default. Users own their data.
- **Accessibility:** Targeted profiles for users ranging from "Granny" (simplified) to "Ghost" (maximum privacy).
- **Developer Flow:** Integrated "Ember-Night" terminal environment using JetBrains Mono for high-productivity coding.

---

## 🚀 Technical Features

### 1. Unified Build Engine (`build_furryos.sh`)

The build engine automates the entire OS lifecycle:

- **Resource Management:** Auto-calculates system limits (Capping RAM at 75% for compression safety).
- **Idempotent Extraction:** Safe ISO/SquashFS extraction with proper permission handoff.
- **Chroot Injection:** Automated package installation and repository management.
- **Fast Prototyping:** Integrated QEMU Test Drive (Phase 8.5) allows testing the unpacked filesystem in seconds without waiting for ISO packing.

### 2. The GENOME Configuration (`GENOME.yaml`)

A centralized YAML specification that governs the OS behavior, asset mapping, and mode-switching logic. This allows developers to change the entire "DNA" of the OS from a single file.

### 3. Identity Modes

- **Granny:** High-contrast, large fonts, simplified UI.
- **Gamer:** Performance-tuned, low-latency audio, compositor disabled.
- **Hacker:** Development tools, ZSH, and advanced terminal utilities.
- **Ghost:** Hardened kernel, MAC randomization, DNS-over-HTTPS, and anti-forensics.

### 4. Ember-Night Terminal Environment

The default developer experience features:

- **Font:** JetBrains Mono Medium (Size 13) for balanced, tight spacing.
- **Color Palette:** Deep Mahogany (`#1A1414`) and Warm Peach (`#FEE2E2`).
- **Optimization:** Native JetBrains Mono injection into the ISO ensures zero letter-spacing artifacts.

---

## 🛠 Prerequisites for Developers

To build FurryOS, your host system requires:

- **Build Tools:** `xorriso`, `squashfs-tools`, `rsync`, `bsdtar`.
- **Python Stack:** `python3`, `pyyaml`, `rich`.
- **Emulation:** `qemu-system-x86`, `ovmf`.
- **Terminal:** `x-terminal-emulator`.

```bash
sudo apt update && sudo apt install -y xorriso squashfs-tools rsync libarchive-tools qemu-system-x86 ovmf python3-yaml fonts-jetbrains-mono
```
